<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Nulla Osta</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 2cm;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .content {
            margin-bottom: 20px;
        }
        .data-row {
            margin-bottom: 10px;
        }
        .label {
            font-weight: bold;
        }
        .section-title {
            font-weight: bold;
            margin-top: 20px;
            margin-bottom: 10px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 0.9em;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>NULLA OSTA</h1>
    </div>

    <div class="content">
        <div class="section-title">Dati Anagrafici</div>
        <div class="data-row">
            <span class="label">Nome:</span> {{ $anagrafica->nome }}
        </div>
        <div class="data-row">
            <span class="label">Cognome:</span> {{ $anagrafica->cognome }}
        </div>
        <div class="data-row">
            <span class="label">Codice Fiscale:</span> {{ $anagrafica->codice_fiscale }}
        </div>
        <div class="data-row">
            <span class="label">Data di Nascita:</span> {{ \Carbon\Carbon::parse($anagrafica->data_nascita)->format('d/m/Y') }}
        </div>
        <div class="data-row">
            <span class="label">Luogo di Nascita:</span> {{ $anagrafica->citta_nascita }} ({{ $anagrafica->provincia_nascita }})
        </div>
        <div class="data-row">
            <span class="label">Regione di Nascita:</span> {{ $anagrafica->regione_nascita }}
        </div>

        <div class="section-title">Residenza</div>
        <div class="data-row">
            <span class="label">Indirizzo:</span> {{ $anagrafica->indirizzo_residenza }}, {{ $anagrafica->numero_civico_residenza }}
        </div>
        <div class="data-row">
            <span class="label">CAP:</span> {{ $anagrafica->cap_residenza }}
        </div>
        <div class="data-row">
            <span class="label">Città:</span> {{ $anagrafica->citta_residenza }} ({{ $anagrafica->provincia_residenza }})
        </div>

        @if($anagrafica->ha_domicilio_diverso)
        <div class="section-title">Domicilio</div>
        <div class="data-row">
            <span class="label">Indirizzo:</span> {{ $anagrafica->domicilio?->indirizzo }}, {{ $anagrafica->domicilio?->numero_civico }}
        </div>
        <div class="data-row">
            <span class="label">CAP:</span> {{ $anagrafica->domicilio?->cap }}
        </div>
        <div class="data-row">
            <span class="label">Città:</span> {{ $anagrafica->domicilio?->citta }} ({{ $anagrafica->domicilio?->provincia }})
        </div>
        @endif

        <div class="section-title">Dati Amministrazione</div>
        <div class="data-row">
            <span class="label">Amministrazione di Appartenenza:</span> {{ $anagrafica->pa_denominazione_rapporto }}
        </div>
        <div class="data-row">
            <span class="label">Tipologia di Esclusione:</span> 
            @switch($anagrafica->pa_esclusione_tipo)
                @case('1')
                    Personale docente universitario a tempo definito
                    @break
                @case('2')
                    Ricercatore universitario a tempo definito
                    @break
                @case('3')
                    Professore universitario a tempo definito
                    @break
                @default
                    {{ $anagrafica->pa_esclusione_tipo }}
            @endswitch
        </div>
        @if($anagrafica->pa_esclusione_dettagli)
        <div class="data-row">
            <span class="label">Dettagli Esclusione:</span> {{ $anagrafica->pa_esclusione_dettagli }}
        </div>
        @endif
    </div>

    <div class="footer">
        Documento generato il {{ now()->format('d/m/Y') }}
    </div>
</body>
</html> 