@extends('layouts.app')

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">

<style>
  body {
    font-family: 'Inter', sans-serif;
  }
</style>

@section('content')
    <div class="py-20">
        <div class="max-w-7xl mx-auto flex justify-center">
            <img class="max-w-[160px]" src="/assets/loghi/iul.jpg" alt="">
        </div>

        <div class="max-w-7xl mx-auto mt-8">
            <div class="text-center">
                @if($type === 'success')
                    <div class="mb-4">
                        <svg class="mx-auto h-12 w-12 text-[#0066CC]" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h2 class="text-2xl font-bold text-[#0066CC] mb-2">Anagrafica Completata</h2>
                @else
                    <div class="mb-4">
                        <svg class="mx-auto h-12 w-12 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                    </div>
                    <h2 class="text-2xl font-bold text-red-500 mb-2">Attenzione</h2>
                @endif
                
                <p class="text-lg text-gray-600">{{ $message }}</p>

                <div class="mt-8">
                    <a href="/" class="inline-flex items-center px-4 py-2 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-[#C7160E] hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        Torna alla home
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection 