<x-filament-panels::page>
    <x-filament::section>
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-lg font-medium">Benvenuto {{ auth()->user()->name }}</h2>
                <p class="mt-1 text-sm text-gray-500">
                    Questa è la tua dashboard personale. Da qui puoi accedere a tutte le funzionalità a te dedicate.
                </p>
            </div>
        </div>
    </x-filament::section>

    <x-filament::section class="mt-6">
        <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
            <!-- Sezione Profilo -->
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <x-heroicon-o-user class="h-6 w-6 text-gray-400" />
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">
                                    Il tuo profilo
                                </dt>
                                <dd class="flex items-baseline">
                                    <div class="text-lg font-semibold text-gray-900">
                                        {{ auth()->user()->email }}
                                    </div>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-5 py-3">
                    <div class="text-sm">
                        <a href="{{ url('/admin/anagrafiche/' . \App\Models\Anagrafica::where('panel_email', auth()->user()->email)->first()?->id) }}" class="font-medium text-primary-600 hover:text-primary-500">
                            Visualizza profilo
                        </a>
                    </div>
                </div>
            </div>

            <!-- Sezione Timesheet -->
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <x-heroicon-o-clock class="h-6 w-6 text-gray-400" />
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">
                                    I tuoi timesheet
                                </dt>
                                <dd class="flex items-baseline">
                                    <div class="text-lg font-semibold text-gray-900">
                                        Gestisci le tue ore
                                    </div>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-5 py-3">
                    <div class="text-sm">
                        <a href="#" class="font-medium text-primary-600 hover:text-primary-500">
                            Vai ai timesheet
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </x-filament::section>
</x-filament-panels::page> 