<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class UserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Crea il ruolo utente se non esiste
        $role = Role::firstOrCreate(['name' => 'utente', 'guard_name' => 'web']);

        // Permessi per l'utente
        $permissions = [
            // Accesso alla dashboard utente
            'page_UserDashboard',
            
            // Visualizzazione della propria anagrafica
            'view_anagrafica',
            
            // Permessi per i timesheet (da implementare)
            'view_timesheet',
            'create_timesheet',
            'update_timesheet',
            'delete_timesheet',
        ];

        // Revoca tutti i permessi esistenti
        $role->syncPermissions([]);

        // Assegna i nuovi permessi
        foreach ($permissions as $permission) {
            $perm = Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
            $role->givePermissionTo($perm);
        }
    }
}
