<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ProvinciaSeeder extends Seeder
{
    public function run()
    {
        $json = File::get("database/data/province.json");
        $province = json_decode($json);

        foreach ($province as $provincia) {
            DB::table('province')->updateOrInsert(
                ['abbreviazione' => $provincia->abbreviazione],
                [
                    'nome' => $provincia->nome,
                    'regione' => $provincia->regione,
                    'capoluogo' => $provincia->capoluogo,
                    'latitudine' => $provincia->latitudine,
                    'longitudine' => $provincia->longitudine,
                ]
            );
        }
    }
}