<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ManagerDidatticoSeeder extends Seeder
{
    public function run(): void
    {
        // Creo l'utente manager didattico
        $user = User::firstOrCreate(
            ['email' => 'manager.didattico@iuline.it'],
            [
                'name' => 'Alessandra Rossi',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]
        );

        // Assegno il ruolo manager_didattico
        $user->assignRole('manager_didattico');
    }
} 