<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ContrattoTemplate;

class ContrattoTemplateSeeder extends Seeder
{
    public function run(): void
    {
        $templates = [
            [
                'nome' => 'Template Personale Strutturato',
                'descrizione' => 'Template per contratti di personale strutturato',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>Professore universitario associato, di ruolo, di II fascia ai sensi dell'art. 18, comma 1 della Legge 30 dicembre 2010, n. 240</h2>
                        </div>
                        
                        <div class="content">
                            <p>L'Università Telematica degli Studi IUL con sede legale in Firenze, via Michelangelo Buonarroti 10 – 50122, Codice Fiscale/P.IVA 05666530489, nella persona del Dott. Massimiliano Bizzocchi, nato a Roma il 27/11/1974, C.F. BZZMSM74S27H501A, munito dei poteri necessari nella sua qualità di Direttore Generale giusta nomina disposta con delibera del Consiglio di Amministrazione</p>

                            <h4>PREMESSO CHE</h4>
                            <ul>
                                <li>Con Decreto del Presidente del Consiglio di Amministrazione n. {{numero_decreto}} l'Ateneo ha bandito la procedura di reclutamento di n. {{numero_posizioni}} Professore Universitario di ruolo di II Area disciplinare AREA {{area}}, Macrosettore: {{macrosettore}}, Settore concorsuale: {{settore_concorsuale}}, {{ssd}};</li>
                                <li>Con Delibera del Dipartimento del {{data_delibera_dipartimento}} è stata proposta la chiamata del candidato prescelto Prof {{nome}} {{cognome}};</li>
                                <li>Con Delibera del Consiglio di Amministrazione del {{data_delibera_cda}} è stata approvata la proposta di chiamata del Dipartimento di cui al precedente punto;</li>
                                <li>Con Decreto presidenziale è stata disposta la nomina nel ruolo di Professore universitario associato di II fascia, del {{nome}} {{cognome}} c.f. {{codice_fiscale}} nato a {{luogo_nascita}} il {{data_nascita}};</li>
                                <li>Ai sensi della normativa vigente, deve essere stipulato apposito contratto individuale di lavoro tra l'Università Telematica degli Studi IUL e {{nome}} {{cognome}}, che regola e definisce gli obblighi reciproci;</li>
                            </ul>

                            <h4>ATTESO CHE</h4>
                            <p>quanto sopra indicato costituisce parte integrante del presente contratto che viene stipulato ai sensi del Decreto Legislativo n. 165 del 2001 e ss.mm.ii, nonché della normativa relativa ai contratti di lavoro delle università;</p>

                            <h4>STIPULA</h4>
                            <p>Con {{nome}} {{cognome}} c.f. {{codice_fiscale}}, nato a {{luogo_nascita}} il {{data_nascita}},</p>

                            <h4>IL SEGUENTE CONTRATTO INDIVIDUALE DI LAVORO</h4>

                            <h4>Articolo 1 - Tipologia del rapporto di lavoro</h4>
                            <p>Il Prof. {{nome}} {{cognome}} viene assunto come Professore universitario di ruolo, di II fascia, con contratto di lavoro subordinato dall'Università Telematica degli Studi IUL.</p>

                            <h4>Articolo 2 - Decorrenza e durata</h4>
                            <p>L'assunzione ha decorrenza giuridica ed economica dal {{data_inizio}}.</p>

                            <h4>Articolo 3 - Inquadramento e sede di lavoro</h4>
                            <p>Ai sensi del D.lgs 165/2001, il dipendente viene inquadrato nel ruolo di Professore universitario di ruolo di II fascia, con contratto di lavoro subordinato presso la sede di via Michelangelo Buonarroti, 10 – 50122 Firenze. In accordo con il Datore di lavoro il dipendente può essere assegnato a specifica sede di servizio sulla base delle effettive esigenze di Ateneo.</p>

                            <h4>Articolo 4 - Mansioni e orario di lavoro</h4>
                            <p>Il dipendente è tenuto allo svolgimento delle mansioni corrispondenti al profilo d'inquadramento, ai sensi della normativa vigente.</p>
                            <p>L'orario di lavoro e lo sviluppo del trattamento economico sono regolati dalle norme vigenti.</p>

                            <h4>Articolo 5 - Trattamento economico</h4>
                            <p>La retribuzione è quella prevista dalla normativa vigente in merito alla qualifica di Professore universitario associato, di ruolo, di II fascia con contratto di lavoro subordinato, in regime di tempo pieno, ai sensi dell'art. 18, comma 1 della legge 30 dicembre 2010, n. 240 ed è determinata nella seguente misura:</p>
                            <ol>
                                <li>Stipendio: Euro {{stipendio}}</li>
                                <li>Tredicesima: {{tredicesima}}</li>
                            </ol>
                            <p>per un totale di Euro {{compenso}} lordo annuo dipendente.</p>
                            <p>Per l'a.a. {{anno_accademico}} il Prof. {{nome}} {{cognome}} ha optato per regime di impegno a tempo {{regime_tempo}}, con il relativo trattamento economico.</p>
                            <p>L'importo sopra indicato è soggetto ad adeguamenti economici nel rispetto dei presupposti di cui alla normativa vigente.</p>
                            <p>Il dipendente può modificare il regime d'impegno scelto presentando apposita domanda almeno 6 mesi prima dell'inizio dell'anno accademico. La decorrenza della modifica del regime d'impegno coincide con l'inizio dell'anno accademico successivo e conseguentemente anche il trattamento economico sarà commisurato al regime di impiego scelto.</p>
                            <p>Gli enti cui verranno versati i contributi previdenziali ed assicurativi, sono INPS, INAIL.</p>

                            <h4>Articolo 6 - Doveri del dipendente</h4>
                            <p>Il dipendente è tenuto a conformare la sua condotta al dovere di collaborare con impegno e responsabilità alla realizzazione dei compiti istituzionali dell'Ateneo, nel rispetto delle disposizioni di legge, Regolamenti interni vigenti e Codice Etico di Ateneo a che costituiscono parte integrante del presente contratto.</p>

                            <h4>Articolo 7 - Tutela dati personali</h4>
                            <p>I dati di cui sopra saranno utilizzati, ai sensi del Regolamento UE 2016/679 – Regolamento Generale per la Protezione dei Dati (GDPR) esclusivamente per scopi inerenti l'esecuzione del Contratto da parte dell'Ateneo. Il dipendente, su richiesta scritta, può chiedere all'Ateneo l'accesso ai propri dati personali e correggere qualsiasi informazione inesatta o incompleta.</p>
                            <p>Il dipendente dal canto suo si impegna a comunicare tempestivamente eventuali variazioni dei dati anagrafici e fiscali dichiarati.</p>

                            <h4>Articolo 8 - Foro Competente</h4>
                            <p>Per ogni controversia derivante dal presente contratto individuale di lavoro è competente il foro di Firenze.</p>

                            <h4>Articolo 9 - Disposizioni di rinvio e cause di risoluzione del contratto di lavoro</h4>
                            <p>Per tutto quanto non previsto dal presente contratto verranno applicate le norme e le condizioni contenute nel Decreto Legislativo n. 165 del 2001 e successive integrazioni e modificazioni, nel codice civile (capo I, titolo II, libro V), nelle leggi sui rapporti di lavoro subordinato dell'impresa e nelle disposizioni normative che disciplinano i rapporti di lavoro delle università.</p>
                            <p>Oltre alle cause di risoluzione previste dalla normativa vigente, costituisce, altresì, condizione risolutiva del presente contratto, senza obbligo di preavviso, l'annullamento della procedura che ne costituisce il presupposto.</p>

                            <p>Letto, confermato e sottoscritto.</p>

                            <div class="signatures">
                                <table style="width: 100%;">
                                    <tr>
                                        <td style="width: 50%;">
                                            <p>Il Dipendente<br>
                                            Prof. {{nome}} {{cognome}}</p>
                                            <p>_____________________</p>
                                        </td>
                                        <td style="width: 50%;">
                                            <p>Il Direttore Generale<br>
                                            Dott. Massimiliano Bizzocchi</p>
                                            <p>__________________________</p>
                                        </td>
                                    </tr>
                                </table>
                            </div>

                            <p style="margin-top: 30px; font-size: 0.8em;">Documento informatico firmato digitalmente ai sensi del T.U. 445/2000 e del D.Lgs. 82/2005 e rispettive norme collegate, il quale sostituisce il documento cartaceo e la firma autografa</p>
                        </div>
                    </body>
                    </html>
HTML,
            ],
            [
                'nome' => 'Template Docenza',
                'descrizione' => 'Template per contratti di docenza',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                            ul { padding-left: 20px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>OGGETTO: Incarico di collaborazione occasionale per docenza</h2>
                        </div>
                        
                        <div class="content">
                            <p>Firenze, {{data_oggi}}</p>
                            
                            <p>Gent. {{nome}} {{cognome}}<br>
                            {{indirizzo}}<br>
                            {{cap}} {{citta}} ({{provincia}})</p>

                            <p>Insegnamento {{corso}}, {{cfu}} CFU, {{semestre}} semestre, {{anno}} anno del Corso di Laurea classe {{classe}} a.a. {{anno_accademico}}</p>

                            <p>Con riferimento al D.M. n. 5 del 2 dicembre 2005, con il quale è stata istituita l'Università Telematica degli Studi IUL, autorizzata ad istituire ed attivare corsi universitari a distanza (laurea e laurea specialistica), master di I e II livello, corsi di perfezionamento, con la presente la incarica la S.V. di svolgere attività di docenza nell'ambito del Corso di Studio e per l'insegnamento di cui in oggetto, utilizzando l'apposita piattaforma online, secondo le indicazioni di seguito specificate e nel dettaglio nella Linea guida sulla didattica:</p>

                            <ul>
                                <li>realizzazione di almeno 2 ore ore di didattica erogativa – DE (complessive per ogni CFU (videolezioni registrate o web lesson);</li>
                                <li>preparazione materiali didattici del Corso;</li>
                                <li>progettazione delle E-tivity e coordinamento, insieme al tutor disciplinare, del gruppo di studenti mediante discussion tematiche utilizzando il forum tematico aperto durante tutto il periodo didattico e altri strumenti asincroni offerti dalla piattaforma IUL (didattica interattiva – DI), per un carico di almeno 4 ore di CFU;</li>
                                <li>organizzazione del calendario didattico dell'insegnamento (esercitazioni e lezioni sincrone) e del ricevimento degli studenti;</li>
                                <li>annotazione nel "registro docente" sul portale Gomp delle attività didattiche svolte durante l'anno accademico (secondo quanto descritto nella Guida per la rendicontazione della didattica), da far approvare dal Presidente del CdS;</li>
                                <li>partecipazione, in presenza, presso le sedi di Ateneo e/o sedi convenzionate, alle Commissioni di esame dell'anno accademico {{anno_accademico}};</li>
                            </ul>

                            <p>Per l'attività proposta in questa sede, l'Università Telematica degli Studi IUL corrisponderà alla S.V. la somma complessiva di Euro {{compenso}} al lordo di IRPEF, al netto di IVA e della quota di contributo previdenziale obbligatoriamente a carico del committente.</p>

                            <p>Il pagamento di detto compenso sarà effettuato previa presentazione di notula/fattura in regola con le norme fiscali, mediante l'accreditamento sul conto corrente postale oppure bancario.</p>

                            <div class="signatures">
                                <p>Il Direttore Generale<br>
                                dell'Università Telematica degli Studi IUL<br>
                                Dott. Massimiliano Bizzocchi</p>

                                <p>Per accettazione<br>
                                {{nome}} {{cognome}}</p>
                            </div>
                        </div>
                    </body>
                    </html>
HTML,
            ],
            [
                'nome' => 'Template Tutoraggio',
                'descrizione' => 'Template per contratti di tutoraggio',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>OGGETTO: Incarico di collaborazione occasionale per tutoraggio</h2>
                        </div>
                        
                        <div class="content">
                            <p>Firenze, {{data_oggi}}</p>
                            
                            <p>Gent. {{nome}} {{cognome}}<br>
                            {{indirizzo}}<br>
                            {{cap}} {{citta}} ({{provincia}})</p>

                            <p>Insegnamento {{corso}}, {{cfu}} CFU, {{semestre}} semestre, {{anno}} anno del Corso di Laurea classe {{classe}} a.a. {{anno_accademico}}</p>

                            <p>Con riferimento al D.M. n. 5 del 2 dicembre 2005, con il quale è stata istituita l'Università Telematica degli Studi IUL, autorizzata ad istituire ed attivare corsi universitari a distanza (laurea e laurea specialistica), master di I e II livello, corsi di perfezionamento, con la presente si incarica la S.V. di svolgere attività di tutoraggio nell'ambito dei Corsi di Studio e per l'insegnamento di cui in oggetto, utilizzando l'apposita piattaforma online.</p>

                            <p>Il presente incarico ha durata dal {{data_inizio}} al {{data_fine}}.</p>

                            <p>Per l'attività proposta in questa sede, l'Università Telematica degli Studi IUL corrisponderà alla S.V. la somma complessiva di Euro {{compenso}} al lordo di IRPEF, al netto di IVA e della quota di contributo previdenziale obbligatoriamente a carico del committente.</p>

                            <p>Il pagamento di detto compenso sarà effettuato previa presentazione di notula in regola con le norme fiscali, mediante accreditamento su conto corrente postale oppure bancario.</p>

                            <div class="signatures">
                                <p>Il Direttore Generale<br>
                                dell'Università Telematica degli Studi IUL<br>
                                Dott. Massimiliano Bizzocchi</p>

                                <p>Per accettazione<br>
                                {{nome}} {{cognome}}</p>
                            </div>
                        </div>
                    </body>
                    </html>
HTML,
            ],
            [
                'nome' => 'Template Lavoro Dipendente',
                'descrizione' => 'Template per contratti di lavoro dipendente',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>CONTRATTO DI LAVORO DIPENDENTE A TEMPO {{tipo_tempo}}</h2>
                        </div>
                        
                        <div class="content">
                            <p>TRA</p>

                            <p>L'UNIVERSITA TELEMATICA DEGLI STUDI IUL, con sede in Firenze, via Buonarroti, n. 10, codice fiscale C.F. 05666530489, rappresentato per il presente atto dal Dott. Massimiliano Bizzocchi nella sua qualità di Direttore Generale dell'Ente</p>

                            <p>E</p>

                            <p>{{nome}} {{cognome}}, CF {{codice_fiscale}}, residente in {{indirizzo}}, {{cap}} {{citta}} ({{provincia}})</p>

                            <h3>SI CONVIENE E SI STIPULA QUANTO SEGUE</h3>

                            <p>1. Il dipendente viene assunto con rapporto di lavoro a tempo {{tipo_orario}} e {{tipo_tempo}} con decorrenza dal {{data_inizio}}.</p>

                            <p>2. Il dipendente viene inquadrato nel Profilo di {{profilo}}, livello {{livello}} CCNL, presso la sede di Firenze.</p>

                            <p>3. L'orario di lavoro sarà di {{ore_settimanali}} ore settimanali.</p>

                            <p>4. La retribuzione lorda mensile è di Euro {{retribuzione_mensile}} e la retribuzione annua lorda è di Euro {{retribuzione_annua}}.</p>

                            <div class="signatures">
                                <p>Il Direttore Generale<br>
                                dell'Università Telematica degli Studi IUL<br>
                                Dott. Massimiliano Bizzocchi</p>

                                <p>Il Dipendente<br>
                                {{nome}} {{cognome}}</p>
                            </div>
                        </div>
                    </body>
                    </html>
HTML,
            ],
            [
                'nome' => 'Template Collaborazione Occasionale',
                'descrizione' => 'Template per contratti di collaborazione occasionale',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>OGGETTO: Incarico di collaborazione occasionale</h2>
                        </div>
                        
                        <div class="content">
                            <p>Firenze, {{data_oggi}}</p>
                            
                            <p>Gent. {{nome}} {{cognome}}<br>
                            {{indirizzo}}<br>
                            {{cap}} {{citta}} ({{provincia}})</p>

                            <p>Con riferimento al D.M. n. 5 del 2 dicembre 2005, con il quale è stata istituita l'Università Telematica degli Studi IUL, autorizzata ad istituire ed attivare corsi universitari a distanza (laurea e laurea specialistica, master di I e II livello, corsi di perfezionamento), con la presente si incarica la S.V. di svolgere {{descrizione_incarico}}.</p>

                            <p>Il presente incarico ha durata dal {{data_inizio}} al {{data_fine}}.</p>

                            <p>Per l'attività proposta in questa sede, l'Università Telematica degli Studi IUL corrisponderà alla S.V. la somma complessiva di Euro {{compenso}} al lordo di IRPEF, al netto di IVA e della quota di contributo previdenziale obbligatoriamente a carico del committente.</p>

                            <p>Il pagamento di detto compenso sarà effettuato previa presentazione di notula in regola con le norme fiscali, mediante accreditamento su conto corrente postale oppure bancario.</p>

                            <div class="signatures">
                                <p>Il Direttore Generale<br>
                                dell'Università Telematica degli Studi IUL<br>
                                Dott. Massimiliano Bizzocchi</p>

                                <p>Per accettazione<br>
                                {{nome}} {{cognome}}</p>
                            </div>
                        </div>
                    </body>
                    </html>
HTML,
            ],
            [
                'nome' => 'Template COCOCO',
                'descrizione' => 'Template per contratti di collaborazione coordinata e continuativa',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>CONTRATTO DI COLLABORAZIONE COORDINATA E CONTINUATIVA</h2>
                        </div>
                        
                        <div class="content">
                            <p>TRA</p>

                            <p>L'Università telematica degli Studi IUL con sede legale in Firenze, via Michelangelo Buonarroti 10 – 50122, Codice Fiscale/P.IVA 05666530489, rappresentata dal Direttore Generale, Dott. Massimiliano Bizzocchi</p>

                            <p>E</p>

                            <p>{{nome}} {{cognome}}, CF {{codice_fiscale}}, residente in {{indirizzo}}, {{cap}} {{citta}} ({{provincia}})</p>

                            <h3>SI CONVIENE E SI STIPULA QUANTO SEGUE</h3>

                            <p>1. OGGETTO DELLA COLLABORAZIONE<br>
                            Il Collaboratore si impegna a svolgere {{descrizione_incarico}}.</p>

                            <p>2. DURATA<br>
                            Il presente contratto ha durata dal {{data_inizio}} al {{data_fine}}.</p>

                            <p>3. COMPENSO<br>
                            Per la collaborazione descritta, il Committente si impegna a corrispondere al Collaboratore il compenso di Euro {{compenso}} al lordo di IRPEF e al netto della quota del contributo previdenziale obbligatoriamente a carico del Committente.</p>

                            <div class="signatures">
                                <p>Il Direttore Generale<br>
                                dell'Università Telematica degli Studi IUL<br>
                                Dott. Massimiliano Bizzocchi</p>

                                <p>Il Collaboratore<br>
                                {{nome}} {{cognome}}</p>
                            </div>
                        </div>
                    </body>
                    </html>
HTML,
            ],
            [
                'nome' => 'Template Collaborazione Autonoma',
                'descrizione' => 'Template per contratti di collaborazione autonoma (P.IVA)',
                'contenuto' => <<<HTML
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <style>
                            body { font-family: Arial, sans-serif; line-height: 1.6; }
                            .header { text-align: center; margin-bottom: 30px; }
                            .content { margin: 20px; }
                            .signatures { margin-top: 50px; }
                        </style>
                    </head>
                    <body>
                        <div class="header">
                            <h2>CONTRATTO DI COLLABORAZIONE AUTONOMA</h2>
                        </div>
                        
                        <div class="content">
                            <p>TRA</p>

                            <p>L'Università Telematica degli Studi IUL, con sede legale in Firenze, via Michelangelo Buonarroti 10 – 50122, Codice Fiscale/P.IVA 05666530489, rappresentata dal Direttore Generale, Dott. Massimiliano Bizzocchi</p>

                            <p>E</p>

                            <p>{{nome}} {{cognome}}, CF {{codice_fiscale}}, P.IVA {{partita_iva}}, residente in {{indirizzo}}, {{cap}} {{citta}} ({{provincia}})</p>

                            <h3>SI CONVIENE E SI STIPULA QUANTO SEGUE</h3>

                            <p>1. OGGETTO DELLA COLLABORAZIONE<br>
                            Il Collaboratore si impegna a svolgere {{descrizione_incarico}}.</p>

                            <p>2. DURATA<br>
                            Il presente contratto ha durata dal {{data_inizio}} al {{data_fine}}.</p>

                            <p>3. COMPENSO<br>
                            Per la collaborazione descritta, il Committente si impegna a corrispondere al Collaboratore il compenso di Euro {{compenso}} al lordo di IRPEF ed al netto di IVA e cassa.</p>

                            <div class="signatures">
                                <p>Il Direttore Generale<br>
                                dell'Università Telematica degli Studi IUL<br>
                                Dott. Massimiliano Bizzocchi</p>

                                <p>Il Collaboratore<br>
                                {{nome}} {{cognome}}</p>
                            </div>
                        </div>
                    </body>
                    </html>
HTML,
            ],
        ];

        foreach ($templates as $template) {
            ContrattoTemplate::updateOrCreate(
                ['nome' => $template['nome']],
                [
                    'descrizione' => $template['descrizione'],
                    'contenuto' => $template['contenuto'],
                ]
            );
        }
    }
} 