<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

use App\Models\Comune;
use Illuminate\Support\Facades\File;


class ComuniSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $json = File::get("database/data/comuni.json");
        $comuni = json_decode($json);

        foreach ($comuni as $comune) {
            Comune::updateOrCreate(
                ['codice' => $comune->codice],
                [
                    'nome' => $comune->nome,
                    'nome_straniero' => $comune->nomeStraniero,
                    'codice_catastale' => $comune->codiceCatastale,
                    'cap' => $comune->cap,
                    'prefisso' => $comune->prefisso,
                    'provincia' => $comune->provincia->nome,
                    'regione' => $comune->provincia->regione,
                    'email' => $comune->email,
                    'pec' => $comune->pec,
                    'telefono' => $comune->telefono,
                    'fax' => $comune->fax,
                    'lat' => $comune->coordinate->lat,
                    'lng' => $comune->coordinate->lng,
                ]
            );
        }
    }
}
