<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->unsignedBigInteger('corso_id')->nullable();
            $table->integer('cfu')->nullable();
            $table->enum('semestre', ['1', '2'])->nullable();
            $table->integer('anno')->nullable();
            $table->string('classe')->nullable();
            $table->string('anno_accademico')->nullable();
            $table->string('profilo')->nullable();
            $table->text('mansioni')->nullable();
            $table->enum('tipo_tempo', ['determinato', 'indeterminato'])->nullable();
            $table->enum('tipo_orario', ['pieno', 'parziale'])->nullable();
            $table->string('livello')->nullable();
            $table->integer('ore_settimanali')->nullable();
            $table->decimal('retribuzione_mensile', 10, 2)->nullable();
            $table->decimal('retribuzione_annua', 10, 2)->nullable();
            $table->foreign('corso_id')->references('id')->on('corsi')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropForeign(['corso_id']);
            $table->dropColumn([
                'corso_id', 'cfu', 'semestre', 'anno', 'classe', 'anno_accademico',
                'profilo', 'mansioni', 'tipo_tempo', 'tipo_orario', 'livello',
                'ore_settimanali', 'retribuzione_mensile', 'retribuzione_annua'
            ]);
        });
    }
};
