<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->string('cv_path')->nullable()->after('email');
            $table->string('cv_original_filename')->nullable()->after('cv_path');
            $table->timestamp('cv_updated_at')->nullable()->after('cv_original_filename');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->dropColumn(['cv_path', 'cv_original_filename', 'cv_updated_at']);
        });
    }
};
