<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('proposta_corsos', function (Blueprint $table) {
            if (!Schema::hasColumn('proposta_corsos', 'selection_closed')) {
                $table->boolean('selection_closed')->default(false);
            }
            if (!Schema::hasColumn('proposta_corsos', 'selection_closed_at')) {
                $table->timestamp('selection_closed_at')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('proposta_corsos', function (Blueprint $table) {
            $table->dropColumn(['selection_closed', 'selection_closed_at']);
        });
    }
};
