<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modulo_proposta_corsos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('proposta_corso_id')->constrained('proposta_corsos')->cascadeOnDelete();
            $table->string('denominazione');
            $table->string('ssd');
            $table->integer('cfu');
            $table->integer('ore');
            $table->integer('numero_modulo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('modulo_proposta_corsos');
    }
};
