<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->date('project_data_inizio')->nullable()->after('ore_progetto');
            $table->date('project_data_fine')->nullable()->after('project_data_inizio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropColumn(['project_data_inizio', 'project_data_fine']);
        });
    }
};
