<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->boolean('has_panel_access')->default(false);
            $table->string('panel_email')->nullable()->unique();
            $table->timestamp('panel_access_created_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->dropColumn(['has_panel_access', 'panel_email', 'panel_access_created_at']);
        });
    }
};
