<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('budget_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->cascadeOnDelete();
            $table->foreignId('work_package_id')->constrained()->cascadeOnDelete();
            $table->foreignId('budget_subcategory_id')->constrained()->cascadeOnDelete();
            $table->date('start_date');
            $table->date('end_date');
            $table->decimal('gross_amount', 15, 2); // Importo lordo
            $table->decimal('reported_amount', 15, 2)->default(0); // Importo rendicontato
            $table->decimal('to_report_amount', 15, 2)->virtualAs('gross_amount - reported_amount'); // Importo da rendicontare
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('budget_items');
    }
}; 