<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('funding_body_project', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->cascadeOnDelete();
            $table->foreignId('funding_body_id')->constrained()->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['project_id', 'funding_body_id']);
        });

        // Migra i dati esistenti dalla vecchia relazione alla nuova tabella pivot
        if (Schema::hasColumn('projects', 'funding_body_id')) {
            $projects = DB::table('projects')->whereNotNull('funding_body_id')->get();
            foreach ($projects as $project) {
                DB::table('funding_body_project')->insert([
                    'project_id' => $project->id,
                    'funding_body_id' => $project->funding_body_id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            Schema::table('projects', function (Blueprint $table) {
                $table->dropConstrainedForeignId('funding_body_id');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('funding_body_project');
    }
}; 