<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (!Schema::hasColumn('contratti', 'yousign_signer_id')) {
                $table->string('yousign_signer_id')->nullable()->after('yousign_procedure_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (Schema::hasColumn('contratti', 'yousign_signer_id')) {
                $table->dropColumn('yousign_signer_id');
            }
        });
    }
}; 