<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('corsi', function (Blueprint $table) {
            $table->id();
            $table->foreignId('categoria_id')->constrained('categorie_corsi');
            $table->string('titolo');
            $table->string('codice')->nullable();
            $table->string('anno_accademico')->nullable();
            $table->string('semestre')->nullable();
            $table->string('corso_di_laurea')->nullable();
            $table->integer('cfu')->nullable();
            $table->integer('durata_anni')->nullable();
            $table->string('ssd')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('corsi');
    }
};
