<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Sushi\Sushi;
use Illuminate\Support\Facades\DB;

class SupabaseUser extends Model
{
    use Sushi;

    protected $connection = 'supabase2';

    public function getRows()
    {
        return DB::connection('supabase2')
            ->table('conversations')
            ->select('user_email', DB::raw('MAX(created_at) as last_message_at'), DB::raw('COUNT(*) as message_count'))
            ->groupBy('user_email')
            ->orderBy('last_message_at', 'desc')
            ->get()
            ->map(function ($item) {
                return [
                    'user_email' => $item->user_email,
                    'last_message_at' => $item->last_message_at,
                    'message_count' => $item->message_count,
                ];
            })
            ->toArray();
    }
}
