<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PropostaCorso extends Model
{
    use HasFactory;

    protected $fillable = [
        'titolo',
        'tipologia_percorso',
        'titolo_esteso',
        'cfu',
        'modalita_erogazione',
        'anno_accademico',
        'direttore_corso',
        'coordinatore_corso',
        'obiettivi_finalita',
        'destinatari',
        'durata',
        'coerenza_metodologia',
        'modalita_conseguimento',
        'costo_iscrizione',
        'partner_scientifici',
        'partner_organizzativi',
        'stato',
        'is_completed'
    ];

    public function moduli(): HasMany
    {
        return $this->hasMany(ModuloPropostaCorso::class);
    }

    public function figureProfessionali(): HasMany
    {
        return $this->hasMany(FiguraProfessionalePropostaCorso::class);
    }
}
