<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Firmatario extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'firmatari';

    protected $fillable = [
        'nome',
        'cognome',
        'titolo',
        'ruolo',
        'email',
        'codice',
        'attivo'
    ];

    protected $casts = [
        'attivo' => 'boolean',
    ];

    protected $appends = ['nome_completo'];

    public function getFullNameAttribute(): string
    {
        return "{$this->nome} {$this->cognome}";
    }

    public function getNomeCompletoAttribute(): string
    {
        return "{$this->titolo} {$this->nome} {$this->cognome} - {$this->ruolo}";
    }
}
