<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Comune extends Model
{
    use HasFactory;

    protected $table = 'comuni';

    protected $fillable = [
        'codice', 'nome', 'nome_straniero', 'codice_catastale', 'cap', 'prefisso',
        'provincia', 'regione', 'email', 'pec', 'telefono', 'fax', 'lat', 'lng'
    ];

    protected $appends = ['nome_con_regione'];

    public function getNomeConRegioneAttribute()
    {
        return "{$this->nome} ({$this->regione})";
    }
}
