<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BudgetItem extends Model
{
    protected $fillable = [
        'project_id',
        'work_package_id',
        'budget_subcategory_id',
        'start_date',
        'end_date',
        'gross_amount',
        'reported_amount',
        'notes',
    ];

    protected $attributes = [
        'gross_amount' => 0,
        'reported_amount' => 0,
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'gross_amount' => 'decimal:2',
        'reported_amount' => 'decimal:2',
        'to_report_amount' => 'decimal:2',
    ];

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function workPackage(): BelongsTo
    {
        return $this->belongsTo(WorkPackage::class);
    }

    public function subcategory(): BelongsTo
    {
        return $this->belongsTo(BudgetSubcategory::class, 'budget_subcategory_id');
    }

    public function person()
    {
        return $this->belongsTo(Anagrafica::class, 'anagrafiche_project');
    }

} 
