<?php

namespace App\Mail;

use App\Models\Candidature;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CandidatureInvitation extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public Candidature $candidature)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Invito a completare la candidatura - IUL',
        );
    }

    public function content(): Content
    {
        $url = route('complete-candidature', ['token' => $this->candidature->invitation_token]);

        return new Content(
            markdown: 'emails.candidature.invitation',
            with: [
                'url' => $url,
                'nome' => $this->candidature->nome,
                'cognome' => $this->candidature->cognome,
                'corso' => $this->candidature->propostaCorso->titolo,
            ],
        );
    }
} 