<?php

namespace App\Mail;

use App\Models\Candidature;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CandidatureCompleted extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public Candidature $candidature)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Nuova candidatura completata - IUL',
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.candidature.completed',
            with: [
                'nome' => $this->candidature->nome,
                'cognome' => $this->candidature->cognome,
                'corso' => $this->candidature->propostaCorso->titolo,
                'cv_url' => url('storage/' . $this->candidature->cv_path),
            ],
        );
    }
} 