<?php

namespace App\Jobs;

use App\Models\Anagrafica;
use App\Mail\StaffAnagraficaCompleted;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendStaffAnagraficaCompletedNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        public Anagrafica $anagrafica
    ) {}

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        \Log::info('Job SendStaffAnagraficaCompletedNotification started');
        $staffEmails = config('mail.staff_emails');
        \Log::info('Staff emails: ' . json_encode($staffEmails));
        
        if (!empty($staffEmails)) {
            try {
                Mail::to($staffEmails)->send(new StaffAnagraficaCompleted($this->anagrafica));
                \Log::info('Email sent successfully');
            } catch (\Exception $e) {
                \Log::error('Error sending email: ' . $e->getMessage());
            }
        } else {
            \Log::warning('No staff emails configured');
        }
    }
}