<?php

namespace App\Http\Controllers;

use App\Models\PropostaCorso;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Mail;
use App\Mail\PropostaCorsoInviata;

class PropostaCorsoController extends Controller
{
    public function generatePdf(PropostaCorso $propostaCorso)
    {
        $pdf = PDF::loadView('pdf.proposta-corso', ['proposta' => $propostaCorso]);
        return $pdf->stream('proposta-corso-' . $propostaCorso->id . '.pdf');
    }

    public function inviaPerApprovazione(PropostaCorso $propostaCorso)
    {
        // Assicurati che la directory esista
        $directory = storage_path('app/public/proposte-corsi');
        if (!file_exists($directory)) {
            mkdir($directory, 0755, true);
        }

        // Genera il PDF
        $pdf = PDF::loadView('pdf.proposta-corso', ['proposta' => $propostaCorso]);
        $pdfPath = $directory . '/' . $propostaCorso->id . '.pdf';
        $pdf->save($pdfPath);

        // Invia l'email
        Mail::to('segreteria.organi@iuline.it')
            ->send(new PropostaCorsoInviata($propostaCorso, $pdfPath));

        // Aggiorna lo stato
        $propostaCorso->update(['stato' => 'inviata']);

        return response()->json(['success' => true]);
    }
} 