<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use App\Models\Anagrafica;

class CvDownloadController extends Controller
{
    public function download($id)
    {
        // Verifica che l'utente sia autenticato
        if (!Auth::check()) {
            abort(403);
        }

        // Recupera l'anagrafica
        $anagrafica = Anagrafica::findOrFail($id);

        // Verifica che il CV esista
        if (!$anagrafica->cv_path || !Storage::disk('local')->exists($anagrafica->cv_path)) {
            abort(404);
        }

        // Restituisci il file
        return Storage::disk('local')->download(
            $anagrafica->cv_path,
            $anagrafica->cv_original_filename ?? 'cv.pdf',
            ['Content-Type' => 'application/pdf']
        );
    }
} 