<?php

namespace App\Filament\Widgets;

use App\Models\Anagrafica;
use Filament\Widgets\ChartWidget;

class AnagraficaCompletionChart extends ChartWidget
{
    protected static ?string $heading = 'Completamento Anagrafiche';

    protected function getData(): array
    {
        $complete = Anagrafica::where('is_complete', true)->count();
        $incomplete = Anagrafica::where('is_complete', false)->count();

        return [
            'datasets' => [
                [
                    'label' => 'Completamento Anagrafiche',
                    'data' => [$complete, $incomplete],
                    'backgroundColor' => ['#10B981', '#EF4444'],
                ],
            ],
            'labels' => ['Complete', 'Incomplete'],
        ];
    }

    protected function getType(): string
    {
        return 'doughnut';
    }

    protected function getOptions(): array
    {
        return [
            'plugins' => [
                'legend' => [
                    'position' => 'bottom',
                ],
            ],
            'maintainAspectRatio' => false,
        ];
    }
}
