<?php

namespace App\Filament\Resources\PropostaCorsoResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class ModuliRelationManager extends RelationManager
{
    protected static string $relationship = 'moduli';

    protected static ?string $title = 'Contenuti';

    protected static ?string $recordTitleAttribute = 'denominazione';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('numero_modulo')
                    ->label('Numero modulo')
                    ->required()
                    ->numeric()
                    ->default(fn ($livewire) => $livewire->getOwnerRecord()->moduli()->count() + 1),
                Forms\Components\TextInput::make('denominazione')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('ssd')
                    ->label('SSD')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('cfu')
                    ->label('CFU')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('ore')
                    ->required()
                    ->numeric()
                    ->default(fn (Forms\Get $get) => $get('cfu') * 25)
                    ->disabled()
                    ->dehydrated(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('denominazione')
            ->columns([
                Tables\Columns\TextColumn::make('numero_modulo')
                    ->label('Numero')
                    ->sortable(),
                Tables\Columns\TextColumn::make('denominazione')
                    ->searchable(),
                Tables\Columns\TextColumn::make('ssd')
                    ->label('SSD')
                    ->searchable(),
                Tables\Columns\TextColumn::make('cfu')
                    ->label('CFU')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('ore')
                    ->numeric()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('numero_modulo', 'asc');
    }
}
