<?php

namespace App\Filament\Resources\PropostaCorsoResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class FigureProfessionaliRelationManager extends RelationManager
{
    protected static string $relationship = 'figureProfessionali';

    protected static ?string $title = 'Figure Professionali';

    protected static ?string $recordTitleAttribute = 'cognome_nome';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('modulo_proposta_corso_id')
                    ->label('Modulo')
                    ->relationship('modulo', 'denominazione')
                    ->required()
                    ->preload()
                    ->createOptionForm([
                        Forms\Components\TextInput::make('denominazione')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('ssd')
                            ->label('SSD')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('cfu')
                            ->label('CFU')
                            ->required()
                            ->numeric(),
                        Forms\Components\TextInput::make('ore')
                            ->required()
                            ->numeric()
                            ->default(fn (Forms\Get $get) => $get('cfu') * 25)
                            ->disabled(),
                    ]),
                Forms\Components\Select::make('ruolo')
                    ->options([
                        'docente' => 'Docente',
                        'tutor_disciplinare' => 'Tutor Disciplinare',
                        'tutor_percorso' => 'Tutor di Percorso',
                    ])
                    ->required(),
                Forms\Components\Grid::make(2)
                    ->schema([
                        Forms\Components\TextInput::make('cognome')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('nome')
                            ->required()
                            ->maxLength(255),
                    ]),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('nome_completo')
            ->columns([
                Tables\Columns\TextColumn::make('modulo.denominazione')
                    ->label('Modulo')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('modulo.ssd')
                    ->label('SSD')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('modulo.cfu')
                    ->label('CFU')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('ruolo')
                    ->searchable(),
                Tables\Columns\TextColumn::make('cognome')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('nome')
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('id', 'asc')
            ->modifyQueryUsing(fn (Builder $query) => $query->with('modulo')->orderBy('modulo_proposta_corso_id', 'asc'));
    }
}
