<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use App\Models\Anagrafica;
use Filament\Actions\Action;
use Illuminate\Support\Facades\Auth;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class UserDashboard extends Page
{
    use HasPageShield;

    protected static ?string $navigationIcon = 'heroicon-o-home';
    protected static ?string $navigationLabel = 'Dashboard Utente';
    protected static ?string $title = 'Dashboard Utente';
    protected static ?int $navigationSort = -2;
    protected static string $view = 'filament.pages.user-dashboard';

    public static function shouldRegisterNavigation(): bool
    {
        return !Auth::user()?->roles()->whereIn('name', ['super_admin', 'admin'])->exists();
    }

    public function mount(): void
    {
        if (Auth::user()?->roles()->whereIn('name', ['super_admin', 'admin'])->exists()) {
            $this->redirect('/admin/dashboard');
        }
    }

    protected function getHeaderActions(): array
    {
        return [
            Action::make('view_profile')
                ->label('Il mio profilo')
                ->icon('heroicon-o-user')
                ->url(fn () => '/admin/anagrafiche/' . Anagrafica::where('panel_email', Auth::user()->email)->first()?->id)
        ];
    }
} 

