<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Illuminate\Support\Facades\Auth;

class Calendario extends Page
{
    use HasPageShield;

    protected static ?string $navigationIcon = 'heroicon-o-calendar';
    protected static ?string $navigationLabel = 'Calendario';
    protected static string $view = 'filament.pages.calendario';
    protected static ?int $navigationSort = 3;

    public static function shouldRegisterNavigation(): bool
    {
        // Mostra il calendario solo a super_admin e Staff IUL
        return !Auth::user()?->hasRole('utente');
    }
}
