<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Contratto di {{ $tipoContratto->nome }}</title>
    <style>
        @page {
            margin: 2.5cm 2cm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.6;
            color: #000;
        }
        .header {
            position: fixed;
            top: -2cm;
            left: 0;
            right: 0;
            height: 2cm;
            text-align: center;
        }
        .header img {
            height: 1.5cm;
        }
        h1 {
            font-size: 14pt;
            text-align: center;
            margin-bottom: 20px;
        }
        .date {
            text-align: right;
            margin-bottom: 20px;
        }
        .recipient {
            margin-bottom: 20px;
        }
        .subject {
            font-weight: bold;
            margin-bottom: 20px;
        }
        .content {
            text-align: justify;
        }
        .signature {
            margin-top: 40px;
        }
        .footer {
            font-size: 8pt;
            text-align: center;
            margin-top: 40px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ public_path('assets/loghi/iul.jpg') }}" alt="Logo IUL">
    </div>

    <h1>{{ $tipoContratto->nome }}</h1>

    <div class="date">
        <p>Firenze, {{ now()->format('d/m/Y') }}</p>
    </div>

    <div class="recipient">
        <p>Gent. {{ $anagrafica->nome }} {{ $anagrafica->cognome }}</p>
    </div>

    <div class="subject">
        <p>OGGETTO: {{ $tipoContratto->nome }}</p>
    </div>

    <div class="content">
        <p>Con riferimento al D.M. n. 5 del 2 dicembre 2005, con il quale è stata istituita l'Università Telematica degli Studi IUL, autorizzata ad istituire ed attivare corsi universitari a distanza (laurea e laurea specialistica, master di I e II livello, corsi di perfezionamento), con la presente si incarica la S.V. di svolgere attività di {{ $contratto->descrizione_incarico }} a favore dell'Ateneo.</p>

        <ul>
            <li>partecipazione alle attività formative interne;</li>
            <li>compilazione del questionario di gradimento/valutazione del docente;</li>
            <li>partecipazione alle riunioni degli organi accademici, in conformità con quanto stabilito dallo Statuto e dai regolamenti dell'Università.</li>
        </ul>

        <p>Qualora la S.V. dia la propria disponibilità ad accettare l'incarico di cui trattasi, è invitata a restituire il presente incarico firmato digitalmente. Nel caso sia dipendente di una Pubblica Amministrazione, la documentazione di cui sopra dovrà essere consegnata unitamente all'autorizzazione rilasciata da parte dell'Ente di appartenenza ai sensi dell'art. 53 del D. Lgs. 165/2001.</p>

        <p>Per l'attività proposta in questa sede, l'Università Telematica degli Studi IUL corrisponderà alla S.V. la somma complessiva di € {{ number_format($contratto->compenso, 2, ',', '.') }} (euro {{ NumberFormatter::create('it', NumberFormatter::SPELLOUT)->format($contratto->compenso) }}/00) al lordo di IRPEF, al netto di IVA e della quota di contributo previdenziale obbligatoriamente a carico del committente.</p>

        <p>Il pagamento di detto compenso sarà effettuato previa presentazione di notula/fattura in regola con le norme fiscali, mediante l'accreditamento sul conto corrente postale oppure bancario.</p>

        <p>Nell'ambito dell'attività oggetto del presente contratto potrà essere richiesta la partecipazione a incontri e riunioni di coordinamento presso la sede della IUL.</p>

        <p>Si specifica inoltre che il presente incarico non rientra nell'ipotesi normativa di cui all'art. 2, comma 1, del D.Lgs. 81/15, poiché le modalità di esecuzione sono concordate con questa Amministrazione e comunque non sono in alcun modo organizzate dal committente con riferimento ai tempi e al luogo di lavoro.</p>

        <p>Tutti i dati personali contenuti nel presente incarico saranno trattati da IUL nel rispetto della legislazione vigente, ai sensi del Regolamento UE 2016/679 - Regolamento Generale per la Protezione dei Dati (GDPR) e del D.Lgs. 30 giugno 2003 n. 196 (Codice in materia di protezione dei dati personali).</p>

        <p>La IUL si impegna a rispettare la riservatezza delle informazioni fornite dal collaboratore, così come previsto ai sensi della normativa vigente: "tutti i dati conferiti saranno trattati solo per finalità connesse e strumentali alla gestione della collaborazione, nel rispetto delle disposizioni vigenti".</p>

        <p>Con i più cordiali saluti,</p>
    </div>

    <div class="signature">
        <p>Il Direttore Generale dell'Università Telematica degli Studi IUL</p>
        <p><em>Dott. Massimiliano Bizzocchi</em></p>

        <p>Per accettazione</p>
        <p><em>{{ $anagrafica->nome }} {{ $anagrafica->cognome }}</em></p>
    </div>

    <div class="footer">
        <p>Documento informatico firmato digitalmente ai sensi del T.U. 445/2000 e del D.Lgs. 82/2005 e rispettive norme collegate, il quale sostituisce il documento cartaceo e la firma autografa</p>
    </div>
</body>
</html>