<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contratto di Tutoraggio</title>
    <style>
        @page { 
            margin: 180px 50px;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            margin: 0;
            padding: 0;
        }
        #header { 
            position: fixed; 
            left: 0px; 
            top: -160px; 
            right: 0px; 
            text-align: center;
        }
        .logo {
            position: absolute;
            top: 0;
            left: 20px;
            width: 150px;
            height: auto;
        }
        #content {
            margin: 0 20px;
        }
        .date-location {
            text-align: right;
            margin-bottom: 30px;
        }
        .recipient {
            margin-bottom: 30px;
        }
        .subject {
            font-weight: bold;
            margin-bottom: 30px;
            text-transform: uppercase;
        }
        .bullet-list {
            list-style-type: none;
            padding-left: 20px;
        }
        .bullet-list li {
            margin-bottom: 10px;
            text-indent: -20px;
            padding-left: 20px;
        }
        .bullet-list li:before {
            content: "•";
            padding-right: 10px;
        }
        .signature {
            margin-top: 50px;
        }
        .signature-line {
            border-top: 1px solid black;
            width: 200px;
            display: inline-block;
            margin-top: 30px;
        }
        .digital-signature-notice {
            font-size: 10px;
            font-style: italic;
            margin-top: 40px;
            color: #666;
        }
        #footer { 
            position: fixed; 
            left: 0px; 
            bottom: -160px; 
            right: 0px; 
            height: 150px;
            padding-left: 20px;
            color: #6B9AC4;
            font-size: 10px;
            line-height: 1.4;
        }
        #footer p {
            margin: 0;
        }
    </style>
</head>
<body>
    <div id="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div id="footer">
        <p>50122 Firenze</p>
        <p>Via M. Buonarroti 10</p>
        <p>cod. fis./p. iva 05666530489</p>
        <p>&nbsp;</p>
        <p>tel. +39 055 0380900</p>
        <p>www.iuline.it</p>
    </div>

    <div id="content">
        <div class="date-location">
            <p>Firenze, {{now()->format('d/m/Y')}}</p>
        </div>

        <div class="recipient">
            <p>Gent.le<br>
            {{$contratto->anagrafica->nome_completo ?? '_________'}}<br>
            {{$contratto->anagrafica->indirizzo_residenza ?? '_________'}}<br>
            {{$contratto->anagrafica->cap_residenza ?? '_____'}} {{$contratto->anagrafica->citta_residenza ?? '_________'}}</p>
        </div>

        <div class="subject">
            <p>OGGETTO: Incarico di collaborazione occasionale per tutoraggio nell'ambito dell'insegnamento "{{$contratto->corso->titolo}}", {{$contratto->cfu}} CFU, {{$contratto->semestre == '1' ? 'primo' : 'secondo'}} semestre, {{$contratto->anno}} anno del Corso di Laurea classe {{$contratto->classe}} a.a. {{$contratto->anno_accademico}}</p>
        </div>

        <p>Con riferimento al D.M. n. 5 del 2 dicembre 2005, con il quale è stata istituita l'Università Telematica degli Studi IUL, autorizzata ad istituire ed attivare corsi universitari a distanza (laurea e laurea specialistica, master di I e II livello, corsi di perfezionamento), con la presente si incarica la S.V. di svolgere attività di tutoraggio nell'ambito dei Corsi di Studio e per l'insegnamento di cui in oggetto, utilizzando l'apposita piattaforma online, secondo le indicazioni di seguito specificate e descritte nel dettaglio nelle Linee guida sulla didattica e Linee guida per tutor:</p>

        <ul class="bullet-list">
            <li>caricamento del programma e dei materiali didattici dell'insegnamento nella piattaforma IUL;</li>
            <li>guida/consulenza e supporto alla classe di studenti per migliorare la comprensione dei contenuti e del materiale didattico mediante incontri in videoconferenza da organizzarsi nel semestre dell'insegnamento dell'a.a. {{$contratto->anno_accademico}} e mediante gli strumenti asincroni offerti dalla piattaforma;</li>
            <li>coordinamento del gruppo di studenti mediante discussioni tematiche nel forum aperto durante tutto il periodo didattico;</li>
            <li>validazione delle e-tivity;</li>
            <li>partecipazione, anche da remoto, alle Commissioni di esame dell'insegnamento tenuto, sino al completamento della prima sessione d'esame dell'anno {{$contratto->anno_accademico}};</li>
            <li>partecipazione alle attività formative interne;</li>
            <li>partecipazione alle riunioni degli organi accademici, in conformità con quanto stabilito dallo Statuto e dai regolamenti dell'Università.</li>
        </ul>

        <p>Qualora la S.V. dia la propria disponibilità ad accettare l'incarico di cui trattasi, è invitata a restituire una copia di questo documento firmata per accettazione. Nel caso sia dipendente di una Pubblica Amministrazione, la documentazione di cui sopra dovrà essere consegnata unitamente all'autorizzazione rilasciata da parte dell'Ente di appartenenza ai sensi dell'art. 53 del D. Lgs. 165/2001.</p>

        <p>Per l'attività di tutoraggio proposta in questa sede, l'Università Telematica degli Studi IUL, corrisponderà alla S.V. la somma complessiva di € {{number_format($contratto->compenso ?? 0, 2, ',', '.')}} al lordo di IRPEF, al netto di IVA e della quota di contributo previdenziale obbligatoriamente a carico del committente.</p>

        <p>Il pagamento di detto compenso sarà effettuato dopo il 31/10/{{now()->addYear()->format('Y')}}, data di conclusione di tutte le attività didattiche e delle sessioni di esame dell'a.a. {{$contratto->anno_accademico}}, previa presentazione di notula/fattura in regola con le norme fiscali, mediante accreditamento su conto corrente postale oppure bancario.</p>

        <p>Nell'ambito dell'attività oggetto del presente contratto potrà essere richiesta la partecipazione a incontri e riunioni di coordinamento presso la sede della IUL.</p>

        <p>Si fa presente che in riferimento alla prestazione occasionale oggetto del presente contratto, tutti i materiali didattici immessi nella sopra citata piattaforma online, verranno considerati produzione accademica di cui l'Università Telematica degli Studi IUL ne conseguirà i relativi diritti di proprietà e patrimoniali.</p>

        <p>Si specifica inoltre che il presente incarico non rientra nell'ipotesi normativa di cui all'art. 2, comma 1, del D.lgs. 81/15, poiché le modalità di esecuzione sono concordate con questa Amministrazione e comunque non sono in alcun modo organizzate dal committente con riferimento ai tempi e al luogo di lavoro.</p>

        <p>Tutti i dati personali contenuti nel presente incarico saranno trattati da IUL nel rispetto della legislazione vigente ai sensi del Regolamento UE 2016/679 - Regolamento Generale per la Protezione dei Dati (GDPR) e del D.Lgs. 30 giugno 2003 n. 196 (Codice in materia di protezione dei dati personali).</p>

        <p>La IUL si impegna a rispettare la riservatezza delle informazioni fornite dal collaboratore, così come previsto ai sensi della normativa vigente: "tutti i dati conferiti saranno trattati solo per finalità connesse e strumentali alla gestione della collaborazione, nel rispetto delle disposizioni vigenti".</p>

        <p>Con i più cordiali saluti,</p>

        <div class="signature">
            <table width="100%">
                <tr>
                    <td width="50%">Per accettazione<br>Dott. {{$contratto->anagrafica->nome_completo ?? '______________'}}</td>
                    <td width="50%">Il Direttore Generale<br>dell'Università Telematica degli Studi IUL<br>Dott. Massimiliano Bizzocchi</td>
                </tr>
                <tr>
                    <td><div class="signature-line"></div></td>
                    <td><div class="signature-line"></div></td>
                </tr>
            </table>
        </div>

        <div class="digital-signature-notice">
            <p>Documento informatico firmato digitalmente ai sensi del T.U. 445/2000 e del D.Lgs. 82/2005 e rispettive norme collegate, il quale sostituisce il documento cartaceo e la firma autografa</p>
        </div>
    </div>
</body>
</html> 