<div class="min-h-screen bg-gray-100 py-6 flex flex-col justify-between">
    <div class="flex-1">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-center mb-8">
                <img src="{{ asset('assets/loghi/logo-iul2.png') }}" alt="Logo IUL" class="h-24">
            </div>

            <div class="relative py-3 sm:max-w-3xl sm:mx-auto">
                <div class="relative px-4 py-10 bg-white mx-8 md:mx-0 shadow rounded-3xl sm:p-10">
                    <div class="max-w-2xl mx-auto">
                        @if($isCompleted)
                            <div class="text-center space-y-6">
                                <div class="text-6xl font-bold text-gray-300">404</div>
                                <h1 class="text-2xl font-semibold text-gray-900">Pagina non disponibile</h1>
                                <div class="text-gray-600 space-y-4">
                                    <p>La candidatura è già stata completata.</p>
                                    <p>Se hai bisogno di assistenza, contatta il supporto tecnico.</p>
                                </div>
                                <div class="pt-6">
                                    <a href="https://www.iuline.it" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-base font-medium rounded-md text-white bg-red-600 hover:bg-red-700">
                                        Torna al sito IUL
                                    </a>
                                </div>
                            </div>
                        @else
                            <div class="space-y-6">
                                <div class="text-center">
                                    <h1 class="text-3xl font-bold text-gray-900">Completa la tua Candidatura</h1>
                                </div>

                                <div class="prose max-w-none">
                                    <p class="text-gray-600 leading-relaxed">
                                        Benvenuto nel processo di candidatura per i corsi IUL. La Italian University Line è lieta di accogliere la tua candidatura per il corso selezionato. Per completare il processo, ti chiediamo di verificare i tuoi dati personali e caricare il tuo curriculum vitae in formato PDF. La tua candidatura sarà esaminata dal nostro team accademico, che valuterà attentamente il tuo profilo in relazione agli obiettivi e ai requisiti del corso.
                                    </p>
                                    <p class="text-gray-600 leading-relaxed mt-4">
                                        Ti ricordiamo che tutti i dati forniti saranno trattati nel rispetto della normativa sulla privacy vigente. Per procedere, è necessario accettare la nostra Privacy Policy.
                                    </p>
                                </div>

                                <div class="divide-y divide-gray-200">
                                    <div class="py-8 text-base leading-6 space-y-4 text-gray-700 sm:text-lg sm:leading-7">
                                        {{ $this->form }}

                                        <div class="pt-4 flex items-center space-x-4">
                                            <button type="button" wire:click="save" class="bg-blue-500 flex justify-center items-center w-full text-white px-4 py-3 rounded-md focus:outline-none hover:bg-blue-600">
                                                Invia Candidatura
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-white shadow mt-8">
        <div class="max-w-7xl mx-auto py-4 px-4 sm:px-6 lg:px-8">
            <div class="text-center text-sm text-gray-500">
                <p>&copy; {{ date('Y') }} IUL - Italian University Line. Tutti i diritti riservati.</p>
                <p class="mt-1">
                    <a href="#" class="text-blue-600 hover:text-blue-800">Privacy Policy</a> |
                    <a href="#" class="text-blue-600 hover:text-blue-800">Cookie Policy</a>
                </p>
            </div>
        </div>
    </footer>
</div> 