@php
    $id = $getId();
    $statePath = $getStatePath();
    $instanceId = $getInstanceId();
    $addressType = $getAddressType();
@endphp

<x-dynamic-component
    :component="$getFieldWrapperView()"
    :field="$field"
>
    <div x-data="{
        state: $wire.entangle('{{ $statePath }}'),
        init() {
            let autocomplete = new google.maps.places.Autocomplete(
                this.$refs.input,
                { types: ['address'], componentRestrictions: { country: 'it' } }
            );

            // Imposta il valore iniziale
            if (this.state) {
                this.$refs.input.value = this.state;
            }

            autocomplete.addListener('place_changed', () => {
                let place = autocomplete.getPlace();
                let streetNumber = '';
                let street = '';
                let postalCode = '';
                let city = '';
                let province = '';

                for (const component of place.address_components) {
                    const componentType = component.types[0];
                    switch (componentType) {
                        case 'street_number':
                            streetNumber = component.long_name;
                            break;
                        case 'route':
                            street = component.long_name;
                            break;
                        case 'postal_code':
                            postalCode = component.long_name;
                            break;
                        case 'locality':
                            city = component.long_name;
                            break;
                        case 'administrative_area_level_2':
                            province = component.short_name;
                            break;
                    }
                }

                if (!streetNumber && street) {
                    const match = street.match(/\d+/);
                    if (match) {
                        streetNumber = match[0];
                        street = street.replace(streetNumber, '').trim();
                    }
                }

                // Imposta solo l'indirizzo nel campo di input
                this.state = `${street} ${streetNumber}`.trim();

                // Usa il tipo di indirizzo passato dal componente
                const fieldPrefix = '{{ $addressType }}';

                // Aggiorna i campi corrispondenti
                $wire.set('data', {
                    ...$wire.get('data'),
                    [`indirizzo_${fieldPrefix}`]: street,
                    [`numero_civico_${fieldPrefix}`]: streetNumber,
                    [`cap_${fieldPrefix}`]: postalCode,
                    [`citta_${fieldPrefix}`]: city,
                    [`provincia_${fieldPrefix}`]: province
                });

                $wire.call('$refresh');
            });

            this.$refs.input.setAttribute('data-instance-id', '{{ $instanceId }}');
            this.$refs.input.autocomplete = autocomplete;
        }
    }">
        <input 
            type="text"
            x-ref="input"
            {{ 
                $attributes
                    ->merge($getExtraInputAttributes())
                    ->class([
                        'block w-full rounded-lg border-gray-300 text-gray-900 shadow-sm outline-none transition duration-75 focus:border-primary-500 focus:ring-1 focus:ring-inset focus:ring-primary-500 disabled:opacity-70',
                        'dark:border-gray-600 dark:bg-gray-700 dark:text-white dark:focus:border-primary-500' => config('forms.dark_mode'),
                    ])
            }}
        />
    </div>
</x-dynamic-component>

@pushOnce('scripts')
<script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}&libraries=places"></script>
@endPushOnce