<div class="space-y-2">
    @foreach($tags as $tag => $description)
        <div class="flex items-center space-x-2">
            <code 
                class="text-sm bg-gray-100 dark:bg-gray-800 px-2 py-1 rounded cursor-pointer hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors"
                x-data="{ copied: false }"
                x-on:click="
                    navigator.clipboard.writeText('{{ $tag }}');
                    copied = true;
                    setTimeout(() => copied = false, 2000);
                "
                x-bind:class="{ 'bg-green-100 dark:bg-green-800': copied }"
            >
                <span x-text="copied ? 'Copiato!' : '{{ $tag }}'"></span>
            </code>
            <span class="text-sm text-gray-600 dark:text-gray-400">{{ $description }}</span>
        </div>
    @endforeach
</div> 