<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Artisan;

class SetupSeeder extends Seeder
{
    public function run(): void
    {
        // Creo l'utente admin se non esiste
        $user = User::firstOrCreate(
            ['email' => 'admin@iuline.it'],
            [
                'name' => 'admin',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]
        );

        // Genero i permessi di Shield
        Artisan::call('shield:generate', [
            '--all' => true,
            '--panel' => 'admin'
        ]);

        // Assegno il ruolo super_admin all'utente
        $superAdminRole = Role::where('name', 'super_admin')->first();
        if ($superAdminRole) {
            $user->assignRole($superAdminRole);
        }

        // $this->command->info('Setup completato con successo!');
    }
}
