<?php

namespace Database\Seeders;

use App\Models\Corso;
use App\Models\CategoriaCorsi;
use Illuminate\Database\Seeder;

class CorsiLaureaSeeder extends Seeder
{
    public function run()
    {
        // Ottieni l'ID della categoria "CORSI DI LAUREA"
        $categoriaId = CategoriaCorsi::where('nome', 'CORSI DI LAUREA')->first()->id;

        $corsi = [
            [
                'titolo' => 'L-19 Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia',
                'corso_di_laurea' => 'Scienze dell\'educazione e della formazione',
                'classe_laurea' => 'L-19',
                'presidente_cds' => 'Prof.ssa Immacolata Messuri',
                'durata_anni' => 3,
                'cfu' => 180,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di scuola secondaria superiore o di altro titolo di studio conseguito all\'estero',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
            [
                'titolo' => 'L-20 Comunicazione innovativa, multimediale e digitale',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale',
                'classe_laurea' => 'L-20',
                'presidente_cds' => 'Dott.ssa Caterina Ferrini',
                'durata_anni' => 3,
                'cfu' => 180,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di scuola secondaria superiore o di altro titolo di studio conseguito all\'estero',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
            [
                'titolo' => 'L-22 Scienze motorie, pratica e gestione delle attività sportive',
                'corso_di_laurea' => 'Scienze Motorie, pratica e gestione delle attività sportive',
                'classe_laurea' => 'L-22',
                'presidente_cds' => 'Prof.ssa Antonella Coppi',
                'durata_anni' => 3,
                'cfu' => 180,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di scuola secondaria superiore o di altro titolo di studio conseguito all\'estero',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
            [
                'titolo' => 'L-24 Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese',
                'corso_di_laurea' => 'Scienze e tecniche psicologiche',
                'classe_laurea' => 'L-24',
                'presidente_cds' => 'Prof.ssa Chiara Mirandola',
                'durata_anni' => 3,
                'cfu' => 180,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di scuola secondaria superiore o di altro titolo di studio conseguito all\'estero',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
            [
                'titolo' => 'L-33 Economia, management e mercati internazionali',
                'corso_di_laurea' => 'Economia, management e mercati internazionali',
                'classe_laurea' => 'L-33',
                'presidente_cds' => 'Prof.ssa Rosa Palladino',
                'durata_anni' => 3,
                'cfu' => 180,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di scuola secondaria superiore o di altro titolo di studio conseguito all\'estero',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
            [
                'titolo' => 'LM-57 Innovazione educativa e apprendimento permanente nella formazione degli adulti in contesti nazionali e internazionali',
                'corso_di_laurea' => 'Innovazione educativa e apprendimento permanente nella formazione degli adulti in contesti nazionali e internazionali',
                'classe_laurea' => 'LM-57',
                'presidente_cds' => 'Prof. Michele Negri',
                'durata_anni' => 2,
                'cfu' => 120,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di laurea triennale o titolo equipollente',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
            [
                'titolo' => 'LM-91 Laurea online interateneo in Innovazione Digitale e Comunicazione',
                'corso_di_laurea' => 'Innovazione Digitale e Comunicazione',
                'classe_laurea' => 'LM-91',
                'presidente_cds' => null,
                'durata_anni' => 2,
                'cfu' => 120,
                'anno_accademico' => '2024/2025',
                'titolo_accesso' => 'Diploma di laurea triennale o titolo equipollente',
                'costo' => 2656.00,
                'categoria_id' => $categoriaId,
            ],
        ];

        foreach ($corsi as $corso) {
            Corso::create($corso);
        }
    }
} 