<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('figura_professionale_proposta_corsos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('proposta_corso_id')->constrained('proposta_corsos')->cascadeOnDelete();
            $table->foreignId('modulo_proposta_corso_id')
                ->constrained('modulo_proposta_corsos')
                ->cascadeOnDelete()
                ->name('fk_figura_prof_modulo');
            $table->enum('ruolo', ['docente', 'tutor_disciplinare', 'tutor_percorso']);
            $table->string('cognome');
            $table->string('nome');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('figura_professionale_proposta_corsos');
    }
};
