<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (!Schema::hasColumn('contratti', 'descrizione_incarico')) {
                $table->text('descrizione_incarico')->nullable();
            }
            if (!Schema::hasColumn('contratti', 'ore_progetto')) {
                $table->integer('ore_progetto')->nullable();
            }
        });
    }

    public function down()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropColumn(['descrizione_incarico', 'ore_progetto']);
        });
    }
}; 