<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('work_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->cascadeOnDelete();
            $table->string('code'); // WP1, WP2, etc.
            $table->string('title');
            $table->text('description')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->string('cost_item')->nullable(); // Voce di costo
            $table->decimal('gross_amount', 12, 2)->default(0); // Importo lordo
            $table->decimal('reported_amount', 12, 2)->default(0); // Importo Rendicontato
            $table->decimal('to_report_amount', 12, 2)->default(0); // Importo da rendicontare
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('work_packages');
    }
};
