<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('acronym')->nullable();
            $table->string('cup_code')->nullable();
            $table->string('announcement')->nullable();
            $table->string('principal_investigator')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('total_months')->nullable();
            $table->string('iul_role')->nullable(); // partner o Capofila
            $table->decimal('total_project_value', 15, 2)->nullable();
            $table->decimal('iul_grant', 15, 2)->nullable();
            $table->decimal('iul_cofinancing', 15, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
