<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            // Rimuovi i vecchi vincoli di unicità
            $table->dropUnique(['email']);
            $table->dropUnique(['codice_fiscale']);
            
            // Aggiungi nuovi vincoli di unicità che considerano deleted_at
            $table->unique(['email', 'deleted_at']);
            $table->unique(['codice_fiscale', 'deleted_at']);
        });
    }

    public function down()
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            // Ripristina i vincoli originali
            $table->dropUnique(['email', 'deleted_at']);
            $table->dropUnique(['codice_fiscale', 'deleted_at']);
            
            $table->unique(['email']);
            $table->unique(['codice_fiscale']);
        });
    }
}; 