<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (!Schema::hasColumn('contratti', 'contenuto_custom')) {
                $table->text('contenuto_custom')->nullable()->after('template_id');
            }
        });
    }

    public function down()
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (Schema::hasColumn('contratti', 'contenuto_custom')) {
                $table->dropColumn('contenuto_custom');
            }
        });
    }
}; 