<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contratti', function (Blueprint $table) {
            $table->id();
            $table->foreignId('anagrafica_id')->constrained('anagrafiche')->onDelete('cascade');
            $table->boolean('lavoro_subordinato_pa')->default(false);
            $table->string('denominazione_pa')->nullable();
            $table->string('indirizzo_pa')->nullable();
            $table->boolean('esclusione_soggettiva')->default(false);
            $table->string('tipo_esclusione')->nullable();
            $table->text('altra_esclusione')->nullable();
            $table->string('numero_autorizzazione')->nullable();
            $table->date('data_autorizzazione')->nullable();
            $table->string('ente_autorizzazione')->nullable();
            $table->boolean('titolare_pensione_diretta')->default(false);
            $table->boolean('non_iscritto_previdenza')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contratti');
    }
};
