<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;
use robertogallea\LaravelCodiceFiscale\CodiceFiscale;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;
use App\Models\BudgetItem;
use App\Observers\BudgetItemObserver;
use App\Models\AnagraficheProject;
use App\Observers\AnagraficheProjectObserver;
use Illuminate\Support\Facades\Gate;

use Filament\Navigation\NavigationBuilder;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
       
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Validator::extend('codice_fiscale', function ($attribute, $value, $parameters, $validator) {
            $cf = new CodiceFiscale();
            if (!$cf->tryParse($value)) {
                return false;
            }

            $data = $validator->getData();
            $firstName = $data[$parameters[0]] ?? '';
            $lastName = $data[$parameters[1]] ?? '';
            $birthdate = $data[$parameters[2]] ?? '';
            $place = $data[$parameters[3]] ?? '';
            $gender = $data[$parameters[4]] ?? '';

            $generatedCF = CodiceFiscale::generate($firstName, $lastName, $birthdate, $place, $gender);

            return $value === $generatedCF;
        });

        

        Filament::serving(function () {
            Filament::registerNavigationGroups([
                'Calendario',
                'Anagrafica',
                'Contratti',
                'Gestione Corsi',
                'Progetti',
                'Finanziario',
                'Corsi',
                'Admin',
                'Filament Shield'
            ]);

        });

      

        BudgetItem::observe(BudgetItemObserver::class);

        // Authorize Laravel Pulse access
        Gate::define('viewPulse', function ($user) {
            return $user->hasRole('super_admin');
        });
    }
}
