<?php

namespace App\Policies;

use App\Models\Anagrafica;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class AnagraficaPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        // Solo gli admin possono vedere la lista delle anagrafiche
        return $user->hasRole(['super_admin', 'admin']);
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Anagrafica $anagrafica): bool
    {
        // Gli utenti possono vedere solo la propria anagrafica
        if ($user->hasRole(['super_admin', 'admin'])) {
            return true;
        }

        return $user->email === $anagrafica->panel_email;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        // Solo gli admin possono creare anagrafiche
        return $user->hasRole(['super_admin', 'admin']);
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Anagrafica $anagrafica): bool
    {
        // Solo gli admin possono modificare le anagrafiche
        return $user->hasRole(['super_admin', 'admin']);
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Anagrafica $anagrafica): bool
    {
        // Solo gli admin possono eliminare le anagrafiche
        return $user->hasRole(['super_admin', 'admin']);
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Anagrafica $anagrafica): bool
    {
        // Solo gli admin possono ripristinare le anagrafiche
        return $user->hasRole(['super_admin', 'admin']);
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Anagrafica $anagrafica): bool
    {
        // Solo gli admin possono eliminare definitivamente le anagrafiche
        return $user->hasRole(['super_admin', 'admin']);
    }
}
