<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TipologiaUtente extends Model
{
    use HasFactory;

    protected $table = 'tipologie_utente';

    protected $fillable = [
        'nome',
        'slug',
        'descrizione',
        'regole'
    ];

    protected $casts = [
        'regole' => 'array'
    ];

    public function anagrafiche()
    {
        return $this->hasMany(Anagrafica::class, 'tipologia_utente', 'slug');
    }
} 